/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.utility.render;

import Krasnodar.rockstarnew.utility.colors.ColorRGBA;
import Krasnodar.rockstarnew.utility.interfaces.IMinecraft;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import lombok.Generated;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public final class Draw3DUtility
implements IMinecraft {
    public static void renderGlowingBox(class_4587 matrices, class_287 buffer, class_238 box, ColorRGBA color) {
        float r = color.getRed();
        float g = color.getGreen();
        float b = color.getBlue();
        float baseAlpha = color.getAlpha();
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        RenderSystem.disableCull();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        int glowLayers = 3;
        float glowStep = 0.1f;
        for (int i = glowLayers; i >= 1; --i) {
            float expand = (float)i * glowStep;
            float alpha = baseAlpha * (0.15f / (float)i);
            Draw3DUtility.renderFilledBox(matrices, buffer, box.method_1014((double)expand), new ColorRGBA(r, g, b, alpha));
        }
        Draw3DUtility.renderFilledBox(matrices, buffer, box, new ColorRGBA(r, g, b, baseAlpha));
        RenderSystem.enableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
    }

    public static void renderFilledBox(class_4587 matrices, class_287 buffer, class_238 box, ColorRGBA color) {
        float r = color.getRed() / 255.0f;
        float g = color.getGreen() / 255.0f;
        float b = color.getBlue() / 255.0f;
        float a = color.getAlpha() / 255.0f;
        Draw3DUtility.renderFilledBox(matrices, buffer, box, r, g, b, a);
    }

    public static void renderBoxInternalDiagonals(class_4587 matrices, class_287 buf, class_238 box, ColorRGBA color) {
        float r = color.getRed() / 255.0f;
        float g = color.getGreen() / 255.0f;
        float b = color.getBlue() / 255.0f;
        float a = color.getAlpha() / 255.0f;
        float minX = (float)box.field_1323;
        float minY = (float)box.field_1322;
        float minZ = (float)box.field_1321;
        float maxX = (float)box.field_1320;
        float maxY = (float)box.field_1325;
        float maxZ = (float)box.field_1324;
        Matrix4f matrix = matrices.method_23760().method_23761();
        buf.method_22918(matrix, minX, minY, minZ).method_22915(r, g, b, a);
        buf.method_22918(matrix, maxX, maxY, maxZ).method_22915(r, g, b, a);
        buf.method_22918(matrix, maxX, minY, minZ).method_22915(r, g, b, a);
        buf.method_22918(matrix, minX, maxY, maxZ).method_22915(r, g, b, a);
        buf.method_22918(matrix, minX, minY, maxZ).method_22915(r, g, b, a);
        buf.method_22918(matrix, maxX, maxY, minZ).method_22915(r, g, b, a);
        buf.method_22918(matrix, maxX, minY, maxZ).method_22915(r, g, b, a);
        buf.method_22918(matrix, minX, maxY, minZ).method_22915(r, g, b, a);
    }

    public static void renderFilledBox(class_4587 matrices, class_287 buffer, class_238 box, float r, float g, float b, float a) {
        float minX = (float)box.field_1323;
        float minY = (float)box.field_1322;
        float minZ = (float)box.field_1321;
        float maxX = (float)box.field_1320;
        float maxY = (float)box.field_1325;
        float maxZ = (float)box.field_1324;
        Matrix4f matrix = matrices.method_23760().method_23761();
        buffer.method_22918(matrix, minX, minY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, minY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, minY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, minY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, maxY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, maxY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, maxY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, maxY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, minY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, minY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, maxY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, maxY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, minY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, minY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, maxY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, maxY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, minY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, minY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, maxY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, maxY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, minY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, minY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, maxY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, maxY, minZ).method_22915(r, g, b, a);
    }

    public static void renderOutlinedBox(class_4587 matrices, class_287 buffer, class_238 box, ColorRGBA color) {
        float r = color.getRed() / 255.0f;
        float g = color.getGreen() / 255.0f;
        float b = color.getBlue() / 255.0f;
        float a = color.getAlpha() / 255.0f;
        float minX = (float)box.field_1323;
        float minY = (float)box.field_1322;
        float minZ = (float)box.field_1321;
        float maxX = (float)box.field_1320;
        float maxY = (float)box.field_1325;
        float maxZ = (float)box.field_1324;
        Matrix4f matrix = matrices.method_23760().method_23761();
        buffer.method_22918(matrix, minX, minY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, minY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, minY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, minY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, minY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, minY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, minY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, minY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, maxY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, maxY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, maxY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, maxY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, maxY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, maxY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, maxY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, maxY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, minY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, maxY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, minY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, maxY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, minY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, maxY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, minY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, maxY, maxZ).method_22915(r, g, b, a);
    }

    public static void drawLine(class_4587 matrices, class_4588 vertexConsumer, class_243 startPos, class_243 endPos, ColorRGBA color) {
        class_4587.class_4665 entry = matrices.method_23760();
        class_243 normalized = endPos.method_1020(startPos).method_1029();
        Vector3f startVector = new Vector3f((float)startPos.field_1352, (float)startPos.field_1351, (float)startPos.field_1350);
        vertexConsumer.method_61032(entry, startVector).method_39415(color.getRGB()).method_60831(entry, (float)normalized.field_1352, (float)normalized.field_1351, (float)normalized.field_1350);
        vertexConsumer.method_56824(entry, (float)endPos.field_1352, (float)endPos.field_1351, (float)endPos.field_1350).method_39415(color.getRGB()).method_60831(entry, (float)normalized.field_1352, (float)normalized.field_1351, (float)normalized.field_1350);
    }

    public static void drawLine(class_4587 matrices, class_287 builder, class_243 startPos, class_243 endPos, ColorRGBA color) {
        class_4587.class_4665 matrixEntry = matrices.method_23760();
        Matrix4f matrix4f = matrixEntry.method_23761();
        class_243 normalized = endPos.method_1020(startPos).method_1029();
        builder.method_22918(matrix4f, (float)startPos.field_1352, (float)startPos.field_1351, (float)startPos.field_1350).method_39415(color.getRGB()).method_60831(matrixEntry, (float)normalized.field_1352, (float)normalized.field_1351, (float)normalized.field_1350);
        builder.method_22918(matrix4f, (float)endPos.field_1352, (float)endPos.field_1351, (float)endPos.field_1350).method_39415(color.getRGB()).method_60831(matrixEntry, (float)normalized.field_1352, (float)normalized.field_1351, (float)normalized.field_1350);
    }

    public static void renderLineFromPlayer(class_4587 matrices, class_287 builder, class_243 endPos, ColorRGBA color) {
        class_4184 camera = Draw3DUtility.mc.field_1773.method_19418();
        class_243 cameraPos = camera.method_19326();
        class_243 cameraRotationVector = new class_243(0.0, 0.0, 27.0).method_1037((float)(-Math.toRadians(camera.method_19329()))).method_1024((float)(-Math.toRadians(camera.method_19330())));
        class_243 cameraRelatedEndPos = endPos.method_1020(cameraPos);
        class_243 startPos = new class_243(cameraRotationVector.method_10216(), cameraRotationVector.method_10214(), cameraRotationVector.method_10215());
        Draw3DUtility.drawLine(matrices, builder, startPos, cameraRelatedEndPos, color);
    }

    @Generated
    private Draw3DUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

